% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{readLAS}
\alias{readLAS}
\title{Read .las or .laz files}
\usage{
readLAS(files, Intensity = TRUE, ReturnNumber = TRUE,
  NumberOfReturns = TRUE, ScanDirectionFlag = FALSE,
  EdgeOfFlightline = FALSE, Classification = TRUE, ScanAngle = TRUE,
  UserData = FALSE, PointSourceID = FALSE, RGB = TRUE, pulseID = TRUE,
  flightlineID = FALSE, color = TRUE, XYZonly = FALSE, all = FALSE,
  filter = "")
}
\arguments{
\item{files}{array of characters or a \link[lidR:catalog]{Catalog} object}

\item{Intensity}{logical. do you want to load the Intensity field? default: TRUE}

\item{ReturnNumber}{logical. do you want to load the ReturnNumber field? default: TRUE}

\item{NumberOfReturns}{logical. do you want to load the NumberOfReturns field? default: TRUE}

\item{ScanDirectionFlag}{logical. do you want to load the ScanDirectionFlag field? default: FALSE}

\item{EdgeOfFlightline}{logical. do you want to load the EdgeOfFlightline field? default: FALSE}

\item{Classification}{logical. do you want to load the Classification field? default: TRUE}

\item{ScanAngle}{logical. do you want to load the ScanAngle field? default: TRUE}

\item{UserData}{logical. do you want to load the UserData field? default: FALSE}

\item{PointSourceID}{logical. do you want to load the PointSourceID field? default: FALSE}

\item{RGB}{logical. do you want to load R,G and B fields? default: TRUE}

\item{pulseID}{logical. do you want to compute the extra field \link[lidR:laspulse]{pulseID}? default: TRUE}

\item{flightlineID}{logical. do you want to compute the extra field \link[lidR:lasflightline]{flightlineID}? default: FALSE}

\item{color}{logical. do you want to compute the extra field \link[lidR:lascolor]{color}? default: FALSE}

\item{XYZonly}{logical. Overwrite all other options. Load only X, Y, Z fields. default: FALSE}

\item{all}{logical. Overwrite all other options. Load everything. default: FALSE}

\item{filter}{character. filter data while reading the file (streaming filter) without
allocating any additional memory. (see \link[rlas:readlasdata]{rlas::readlasdata}).}
}
\value{
A LAS object
}
\description{
Read .las or .laz files in format 1 to 4 according to LAS specification and return an object of class LAS
}
\details{
If several files are given the returned LAS object is considered as one LAS file.
The information retained in the header will be read from the first file in the list.
The optional logical parameters enable the user to save memory by choosing to load only the fields they need. Indeed,
the readLAS function does not 'stream' the data. Data is loaded into the
computer's memory (RAM) suboptimally because R does not accommodate many different data types.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)
}
\seealso{
\link[lidR:LAS-class]{Class LAS}
\link[lidR:catalog]{Catalog}
}
