% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_tools.R
\name{lib_paths}
\alias{lib_paths}
\title{Changing and viewing the package search paths}
\usage{
lib_paths(path, make_path = TRUE, ask = TRUE)
}
\arguments{
\item{path}{(Character, or omit) A path to add to the library search path. Can be an
absolute or relative path. If \code{path} has more than one element, only the first
one will be kept. Tilde expansion is performed on the input, but wildcard expansion
(globbing) is not. If \code{path} is omitted, return the current library search path.}

\item{make_path}{(Logical) If \code{TRUE}, create \code{path}'s directory structure if it doesn't
exist.}

\item{ask}{(Logical) If \code{TRUE}, ask before creating \code{path}'s directory structure if
\code{make_path = TRUE}. Ignored if \code{make_path = FALSE}.}
}
\value{
A character vector of the folders on the library search path. If \code{path} was not
omitted, it will be the first element.
}
\description{
View and edit the list of folders that R will look inside when trying to find a
package. Add an existing folder, create and add a new folder, or shuffle a folder to
the front of the list so that it is used as the default installation location for new
packages in the current session.
}
\examples{
\donttest{
lib_paths()

#> [1] "D:/R/R-3.5.0/library"

lib_paths(file.path(tempdir(), "newlibraryfolder"), ask = FALSE)

#> [1] "C:/Users/.../Temp/Rtmp0Qbvgo/newlibraryfolder"
#> [2] "D:/R/R-3.5.0/library"
}

}
