% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call-numbers-and-subject.R
\name{get_dewey_decimal_subject_class}
\alias{get_dewey_decimal_subject_class}
\title{Conversion from Dewey Decimal call numbers to first-level subject description}
\usage{
get_dewey_decimal_subject_class(x)
}
\arguments{
\item{x}{A Dewey Decimal call number}
}
\value{
Returns the most general subject classification using the
        hundreds places from the DCC. Returns NA if the DCC looks
        invalid
}
\description{
Takes a string representation of a Dewey Decimal
call number (DCC) and returns it's subject description.
This uses the hundreds place of the DCC number
and returns the most general subject classification.
}
\examples{

get_dewey_decimal_subject_class("709.05")     # Arts

get_dewey_decimal_subject_class("823.912")
# Literature (Belles-lettres) and rhetoric

# vectorized
get_dewey_decimal_subject_class(c("709.05", "invalid", NA, "823.912"))
# c("Arts", NA, NA, "Literature (Belles-lettres) and rhetoric")

}
