% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marc-field-deconstruction.R
\name{marc_leader_get_info}
\alias{marc_leader_get_info}
\title{Get info from MARC leader}
\usage{
marc_leader_get_info(x)
}
\arguments{
\item{x}{A string (or vector of strings) of MARC leaders}
}
\value{
A \code{data.table}
}
\description{
Takes one or more MARC leaders (string/strings) and returns a
\code{data.table} containing the record type and bib level
}
\examples{

marc_leader_get_info("00000cam a22000008i 4500")
#          record_type      bib_level
#               <char>         <char>
# 1: Language Material Monograph/Item

# vectorized
marc_leader_get_info(c("00000cam a2200000Ma 4500", NA,
                       "00000cem a2200000Ma 4500"))
#              record_type      bib_level
#                    <char>         <char>
#  1:     Language Material Monograph/Item
#  2:                  <NA>           <NA>
#  3: Cartographic material Monograph/Item

}
