% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{check_isbn_10_check_digit}
\alias{check_isbn_10_check_digit}
\title{Check the check digit of an ISBN 10}
\usage{
check_isbn_10_check_digit(x, allow.hyphens = TRUE, errors.as.false = TRUE)
}
\arguments{
\item{x}{A string of 10 digits or 9 digits with terminal "X"}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{errors.as.false}{return false if error instead of throwing error}
}
\value{
Returns TRUE if check passes, FALSE if not, and NA if NA
}
\description{
Takes a string representation of an ISBN 10 and verifies that check digit
checks out
}
\examples{

check_isbn_10_check_digit("012491540X")      # TRUE
check_isbn_10_check_digit("0-124-91540-X")   # TRUE

# vectorized
check_isbn_10_check_digit(c("012491540X", "9004037812"))  # TRUE FALSE

}
