\name{extract.lgcpPredict}
\alias{extract.lgcpPredict}
\title{extract.lgcpPredict function}
\usage{
\method{extract}{lgcpPredict}(obj, x = NULL, y = NULL, t, s = -1,
  inWindow = NULL, crop2parentwindow = TRUE, ...)
}
\arguments{
  \item{obj}{an object of class lgcpPredict}

  \item{x}{range of x-indices: vector (eg c(2,4))
  corresponding to desired subset of x coordinates. If
  equal to -1, then all cells in this dimension are
  extracted}

  \item{y}{range of y-indices as above}

  \item{t}{range of t-indices: time indices of interest}

  \item{s}{range of s-indices ie the simulation indices of
  interest}

  \item{inWindow}{an observation owin window over which to
  extract the data (alternative to specifying x and y).}

  \item{crop2parentwindow}{logical: whether to only extract
  cells inside obj$xyt$window (the 'parent window')}

  \item{...}{additional arguments}
}
\value{
extracted array
}
\description{
\bold{This function requires data to have been dumped to
disk}: see \code{?dump2dir} and \code{?setoutput}.
\code{extract.lgcpPredict} extracts chunks of data that
have been dumped to disk. The subset of data can either be
specified using an (x,y,t,s) box or (window,t,s) region
where window is a polygonal subregion of interest.
}
\seealso{
\link{lgcpPredict}, \link{loc2poly}, \link{dump2dir},
\link{setoutput}
}

