% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSCLOP.R
\name{getSCLOP}
\alias{getSCLOP}
\alias{getSimilarity.PrototypeLDA}
\alias{getRelevantWords.PrototypeLDA}
\alias{getConsideredWords.PrototypeLDA}
\alias{getMergedTopics}
\alias{getPrototypeID}
\alias{getLDA.PrototypeLDA}
\alias{getID.PrototypeLDA}
\alias{getParam.PrototypeLDA}
\alias{getJob.PrototypeLDA}
\title{Getter for PrototypeLDA}
\usage{
getSCLOP(x)

\method{getSimilarity}{PrototypeLDA}(x)

\method{getRelevantWords}{PrototypeLDA}(x)

\method{getConsideredWords}{PrototypeLDA}(x)

getMergedTopics(x)

getPrototypeID(x)

\method{getLDA}{PrototypeLDA}(x, job, reduce = TRUE, all = FALSE)

\method{getID}{PrototypeLDA}(x)

\method{getParam}{PrototypeLDA}(x)

\method{getJob}{PrototypeLDA}(x)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link[=getPrototype]{PrototypeLDA}} object.}

\item{job}{[\code{\link{data.frame}} or \code{integer}]\cr
A data.frame or data.table with a column named "job.id" or a vector of
integerish job ids. Default is the (integerish) ID of the Prototype LDA.}

\item{reduce}{[\code{logical(1)}]\cr
If the list of LDAs contains only one element, should the list be reduced and
the single (unnamed) element be returned? Default is \code{TRUE}.
Not considered, if \code{all} is \code{TRUE}.}

\item{all}{[\code{logical(1)}]\cr
Shortcut for \code{job}: Should all stored LDAs be returned?}
}
\description{
Returns the corresponding element of a \code{\link[=getPrototype]{PrototypeLDA}} object.
}
\seealso{
Other getter functions: 
\code{\link{getJob}()},
\code{\link{getSimilarity}()},
\code{\link{getTopics}()}

Other PrototypeLDA functions: 
\code{\link{LDAPrototype}()},
\code{\link{getPrototype}()}
}
\concept{PrototypeLDA functions}
\concept{getter functions}
