% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeTopics.R
\name{mergeTopics}
\alias{mergeTopics}
\title{Merge LDA Topic Matrices}
\usage{
mergeTopics(x, vocab, progress = TRUE)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link{LDARep}} or \code{\link{LDABatch}} object.}

\item{vocab}{[\code{character}]\cr
Vocabularies taken into consideration for merging topic matrices.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default ist \code{TRUE}.}
}
\value{
[\code{named matrix}] with the count of vocabularies (row wise) in topics (column wise).
}
\description{
Generic function, which collects LDA results and merges their topic matrices
for a given set of vocabularies.
}
\details{
This function uses the function \code{\link{mergeRepTopics}} or
\code{\link{mergeBatchTopics}}. The topic matrices are transponed and cbinded,
so that the resulting matrix contains the counts of vocabularies/words (row wise)
in topics (column wise).
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 10, num.iterations = 30)
topics = mergeTopics(res, vocab = reuters_vocab)
dim(topics)
length(reuters_vocab)

\donttest{
res = LDABatch(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 10, num.iterations = 30)
topics = mergeTopics(res, vocab = reuters_vocab)
dim(topics)
length(reuters_vocab)
}
}
\seealso{
Other merge functions: 
\code{\link{mergeBatchTopics}()},
\code{\link{mergeRepTopics}()}

Other workflow functions: 
\code{\link{LDARep}()},
\code{\link{SCLOP}()},
\code{\link{dendTopics}()},
\code{\link{getPrototype}()},
\code{\link{jaccardTopics}()}
}
\concept{merge functions}
\concept{workflow functions}
