% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getVarCov.lcc}
\alias{getVarCov.lcc}
\title{Extract Variance Components from a Fitted Model}
\usage{
\method{getVarCov}{lcc}(obj, type, ...)
}
\arguments{
\item{obj}{an object inheriting from class \code{lcc}, representing
a fitted longitudinal concordance correlation function.}

\item{type}{specifies the type of variance covariance matrix. If
\code{type = "random.effects"}, the default, extract the
random-effects variance-covariance; if \code{type = "conditional"}
extract the conditional variance-covariance of the responses; and
if \code{type = "marginal"} extracts the the marginal
variance-covariance of the responses.}

\item{...}{optional arguments passed to the \code{getVarCov}
function.}
}
\description{
Returns the variance-covariance matrix of a fitted
  \code{lcc} model object.
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{

\dontrun{
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
getVarCov(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}},
  \code{\link{coef.lcc}}, \code{\link{vcov.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
