% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqq.R
\name{rqq}
\alias{rqq}
\title{Test of Normality Using RQQ Plots}
\usage{
rqq(
  y,
  plot.it = TRUE,
  square.it = TRUE,
  scale = c("MAD", "J", "classical"),
  location = c("median", "mean"),
  line.it = FALSE,
  line.type = c("45 degrees", "QQ"),
  col.line = 1,
  lwd = 1,
  outliers = FALSE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{y}{the input data.}

\item{plot.it}{logical. Should the result be plotted?}

\item{square.it}{logical. Should the plot scales be square? The default is \code{TRUE}.}

\item{scale}{the choice of a scale estimator, i.e., the classical or robust estimate 
of the standard deviation.}

\item{location}{the choice of a location estimator, i.e., the mean or median.}

\item{line.it}{logical. Should the line be plotted? No line is the default.}

\item{line.type}{If \code{line.it = TRUE}, the choice of a line to be plotted, i.e., 
the 45-degree line or the line passing through the first and third quartiles 
of the data.}

\item{col.line}{the color of the line (if plotted).}

\item{lwd}{the line width (if plotted).}

\item{outliers}{logical. Should the outliers be listed in the output?}

\item{alpha}{significance level of outliers. If \code{outliers = TRUE}, then all 
observations that are less than the \code{100*alpha}-th standard normal percentile or 
greater than the \code{100*(1-alpha)}-th standard normal percentile will be listed 
in the output.}

\item{...}{other parameters passed to the \code{\link[graphics]{plot}} function.}
}
\value{
A list with the following numeric components:
\item{x}{the x-coordinates of the points that were/would be plotted.}
\item{y}{the original data vector, i.e., the corresponding y-coordinates,
including \code{NA}s (if any).}
}
\description{
Produce robust quantile-quantile (RQQ) and classical quantile-quantile (QQ) 
plots for graphical assessment of normality and optionally add a line, a QQ line, 
to the produced plot. The QQ line may be chosen to be a 45-degree line or to pass
through the first and third quartiles of the data. 
\code{NA}s from the data are omitted.
}
\details{
An RQQ plot is a modified QQ plot where data are robustly standardized 
by the median and robust measure of spread (rather than mean and classical 
standard deviation as in the basic QQ plots) and then are plotted against the 
expected standard normal order statistics 
\insertCite{Gel_etal_2005,Weisberg_2005}{lawstat}. 
Under normality, the plot of the standardized 
observations should follow the 45-degree line, or QQ line. Both the median and robust 
standard deviation are significantly less sensitive to outliers than mean and 
classical standard deviation and therefore are more preferable in many practical 
situations to assess graphically deviations from normality (if any). We choose 
median and MAD as a robust measure of location and spread for our RQQ plots since 
this standardization typically provides a clearer graphical diagnostics of normality. 
In particular, deviations from the QQ line are usually more noticeable in RQQ plots 
in the case of outliers and heavy tails. Users can also choose to plot the 
45-degree line or the 1st-3rd quartile line (see the argument \code{line.type}). 
No line is the default.
}
\examples{
## Simulate 100 observations from standard normal distribution:
y = rnorm(100)
rqq(y)

## Using Michigan data
data(michigan)
rqq(michigan)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rjb.test}}, \code{\link{sj.test}}, 
\code{\link[stats]{qqnorm}}, \code{\link[stats]{qqplot}}, \code{\link[stats]{qqline}}
}
\author{
W. Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao
}
\keyword{distribution}
\keyword{robust}
