% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmSingle.R
\name{rmSingle}
\alias{rmSingle}
\title{Remove single tones from patches}
\usage{
rmSingle(rst, rm = TRUE)
}
\arguments{
\item{rst}{input raster landscape.}

\item{rm}{logical, if TRUE returns the raster without single tones cells, if FALSE a vector of numbers identifying the single tones cells.}
}
\value{
a raster without single tones cells. If \code{rm=TRUE}, a vector of numbers identifying the single tones cells.
}
\description{
Patch creation algorithm can occasionally leave single cells scattered within patches.
This function reduces the "salt-pepper" effect, identifying or correcting those cells.
% ADD FUNCTIONALITY NOT ONLY SINGLES BUT USER DEFINED SIZE
}
\examples{
library(raster)
m = matrix(0, 33, 33)
r = raster(m, xmn=0, xmx=10, ymn=0, ymx=10)
patchSize = 500
r = makePatch(r, 578, patchSize, rast=TRUE)
plot(r)

## Introduce a single tone cell and remove it with rmSingle
r[578] = 0
plot( rmSingle(r) )

## Single tones can be identified but not removed:
rmSingle(r, rm = FALSE)
}

