% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-handling.R
\name{post_lambda_error}
\alias{post_lambda_error}
\title{Post an error to an endpoint with the format expected by AWS Lambda}
\usage{
post_lambda_error(e, endpoint)
}
\arguments{
\item{e}{an error as caught by \code{\link[base]{tryCatch}}}

\item{endpoint}{where to \code{\link[httr]{POST}} the error}
}
\description{
According to the
\href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-dg.pdf}{AWS Lambda
Developer Guide} an error posted to the initialisation or invocation error
endpoints must be of content type \code{application/vnd.aws.lambda.error+json}
and of the format:\if{html}{\out{<div class="json">}}\preformatted{\{
  "errorMessage": "...",
  "errorType": "...",
  "stackTrace": [],
\}
}\if{html}{\out{</div>}}

Here the \code{errorMessage} and \code{errorType} are strings, with the \code{stackTrace}
a list of strings.

This function accepts an error as caught by  \code{\link[base]{tryCatch}} and
posts it to the given endpoint, ensuring that the correct formatting is
adhered to. This function does not stop the runtime as in the case of
invocation errors it's desirable to continue.

The stacktrace is not currently reported. This functionality is yet to be
implemented. See the
\href{https://github.com/mdneuzerling/lambdr/issues/5}{GitHub issue} for more
details.
}
\keyword{internal}
