% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/data.frame.R, R/flextable.R,
%   R/matrix.R
\name{add_to_slides}
\alias{add_to_slides}
\alias{add_to_slides.data.frame}
\alias{add_to_slides.flextable}
\alias{add_to_slides.matrix}
\title{Add Object to Slides}
\usage{
add_to_slides(object, presentation_id, on = NULL, object_id, overwrite, ...)

\method{add_to_slides}{data.frame}(
  object,
  presentation_id,
  on = NULL,
  object_id = new_id("table"),
  overwrite = FALSE,
  digits = NULL,
  ...
)

\method{add_to_slides}{flextable}(
  object,
  presentation_id,
  on = NULL,
  object_id = new_id("table"),
  overwrite = FALSE,
  ...
)

\method{add_to_slides}{matrix}(
  object,
  presentation_id,
  on = NULL,
  object_id = new_id("table"),
  overwrite = FALSE,
  digits = NULL,
  ...
)
}
\arguments{
\item{object}{An object to add to slides}

\item{presentation_id}{The id from the Slides presentation}

\item{on}{The id or number of the slide to add \code{object} to}

\item{object_id}{A unique id for the new object on the slides}

\item{overwrite}{If TRUE and an object with \code{object_id} exists it will deleted and replaced.}

\item{...}{Other arguments used in methods}

\item{digits}{the minimum number of significant digits, see \link{format}. If \code{NULL}
\code{getOption("digits")} is used.}
}
\value{
A presentation object updated with the new object. This function is used for its side
effect of adding an object to the slides. The returned object in R is mostly for inspection.
}
\description{
Add Object to Slides
}
\details{
A data.frame object is added as a table with the column names in bold as the first row.
For other formatting use the \code{flextable} package and \link{add_to_slides.flextable}.

A flextable object is added with all formatting.

A matrix object is added as a table without any row or column names.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Add a data.frame
s <- choose_slides()
obj <- iris[1:5, ]
add_to_slides(obj, s, on = 1)
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Add a flextable
s <- choose_slides()
library(flextable)
ft <- flextable(iris[1:5, ])
ft <- theme_box(ft)
ft <- color(ft, i = 1:3, j = 1:2, "pink", part = "body")
ft <- autofit(ft)
add_to_slides(ft, s, on = 1)
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Add a matrix
s <- choose_slides()
obj <- cov(iris[, 1:4])
add_to_slides(obj, s, on = 1)
\dontshow{\}) # examplesIf}
}
