% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbdd.R
\name{rbdd}
\alias{rbdd}
\alias{bddcoverageprob}
\alias{bddlambda}
\alias{bdddiscr}
\alias{bddcovar.iso}
\alias{bddcovar}
\title{Simulation of Boolean Model of Deterministic Discs}
\usage{
rbdd(lambda, discr, window, seed = NULL)

bddcoverageprob(lambda, discr)

bddlambda(coverp, discr)

bdddiscr(coverp, lambda)

bddcovar.iso(r, lambda, discr)

bddcovar(xrange, yrange, eps, lambda, discr)
}
\arguments{
\item{lambda}{Intensity of the germ process (which is a Poisson point
process)}

\item{discr}{Radius of the discs}

\item{window}{The window to simulate in (an \code{owin} object)}

\item{seed}{Optional input (default in NULL). Is an integer passed to
\code{\link[base]{set.seed}}. Used to reproduce patterns exactly.}

\item{coverp}{Coverage probability of the Boolean model}

\item{r}{is the radius to calculate covariance}

\item{xrange}{range of x values for \code{bddcovar}}

\item{yrange}{range of y values for \code{bddcovar}}

\item{eps}{list of length 2 of the steps between samples points in x and y respectively for \code{bddcovar}.
If eps is of length 1 then the steps between sample points in the x and y directions will both be equal to eps.}
}
\value{
See Functions section.
}
\description{
Functions for simulating a Boolean model with grains that are
  discs of fixed constant radius (the abbreviation `bdd' is short for Boolean
  model with Deterministic Discs). A Boolean model is a two stage model,
  first the locations (called germs) of grains are randomly distributed
  according to a Poisson point process, then a random grain is placed on each
  germ independently. Introductions to Boolean models are available in many
  stochastic geometry books (Chiu et al., 2013). Also described here are
  functions for calculating the coverage probability, germ intensity, and
  covariance from model parameters for a Boolean model with deterministic discs.
}
\section{Functions}{
\itemize{
\item \code{rbdd}: Returns an \code{owin} that is a set generated by simulating a Boolean
 model with specified intensity and disc radius.
 The window information is not contained in this object.
 If the simulated set is empty then an empty \code{owin} object is returned.
The point process of germs is generated using \pkg{spatstat}'s \code{\link[spatstat]{rpoispp}}.

\item \code{bddcoverageprob}: Returns the true coverage probability given the intensity and disc radius.

\item \code{bddlambda}: Returns the germ intensity given coverage probability and disc radius.

\item \code{bdddiscr}: Returns the disc radius given coverage probability and germ intensity.

\item \code{bddcovar.iso}: Returns the true covariance of points separated by a distance \code{r} given the intensity, \code{lambda} and disc radius \code{discr} of the model.

\item \code{bddcovar}: Returns an image of the covariance as calculated from disc radius and intensity.
}}

\section{WARNING}{

The returned object of \code{rbdd} is an \code{owin} specifying the realisation of the Boolean model within the simulation window. The simulation window is not included, thus the object returned by \code{rbdd} can have much smaller extent than the simulation window (e.g. when the simulated set is empty).
}

\examples{
# Simulate Boolean model with discs of radius 10.
# The coverage probability is very close to 0.5.
discr <- 10
w <- owin(xrange = c(0, 100), c(0, 100))
lambda <- 2.2064E-3 
xi <- rbdd(lambda, discr, w)

# Compute properties of Boolean model from parameters
cp <- bddcoverageprob(lambda, discr)
cvc <- bddcovar(c(-10, 10), c(-10, 10), c(0.2, 0.2), lambda, discr)
}
\references{
Chiu, S.N., Stoyan, D., Kendall, W.S. and Mecke, J. (2013) \emph{Stochastic Geometry and Its Applications}, 3rd ed. Chichester, United Kingdom: John Wiley & Sons.
}
\keyword{datagen}
\keyword{spatial}
