% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srbind.R
\name{srbind}
\alias{srbind}
\title{Safely Combine Data Frames Row-wise}
\usage{
srbind(...)
}
\arguments{
\item{...}{data.frames to be row-bound}
}
\value{
a data.frame.
}
\description{
\code{srbind} allows one to bind rows together into a data.frame, while preserving
any labelr labels of the inputted data.frames.
}
\details{
Precedence is given to the labels of earlier-appearing arguments, such that,
if both an earlier and a later data.frame include a label attribute with the
same name, the attribute from the earlier data.frame will be preserved, and
the same-named attribute later data.frame(s) will be discarded.
}
\examples{
# assign mtcars to df
df <- mtcars

# assign the rownames to a column
id <- rownames(df)

df <- cbind(id, df)

# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

# split the data.frame into three
aa <- df[1:5, ]
bb <- df[6:11, ]
cc <- df[12:32, ]
# put them back together
df2 <- srbind(aa, bb, cc, cc)

get_val_labs(df2)
}
