\name{plot.kde}
\alias{plot.kde}

\title{Kernel density estimate plot for 2- and 3-dimensional data}
\description{
  Kernel density estimate plot for 2- and 3-dimensional data.
}

\synopsis{\method{plot}{kde}(x, display="slice", ...)}

\usage{
## bivariate
\method{plot}{kde}(fhat, display="slice", cont=c(25,50,75), ncont=NULL,cex=0.7, 
    xlabs="x", ylabs="y", zlabs="Density function", theta=-30,
    phi=40, d=4, add=FALSE, drawlabels=TRUE, points.diff=TRUE,
    pch, ptcol="blue", lcol="black", ...)

## trivariate
\method{plot}{kde}(fhat, display="rgl", cont=c(25,50,75), colors, alphavec,
    size=3, ptcol="blue", add=FALSE, origin=c(0,0,0), endpts,
    xlabs="x", ylabs="y", zlabs="z", ...)
}

\arguments{
  \item{fhat}{an object of class \code{kde} i.e. output from
    \code{\link{kde}} function}
  \item{display}{type of display, "slice" for contour plot, "persp" for
    perspective plot, "image" for image plot, "rgl" for RGL plot}
  \item{cont}{vector of percentages (of maximum height) for contour
    level curves}
  \item{ncont}{number of contour level curves}
  \item{ptcol}{plotting colour for data points}
  \item{lcol}{plotting colour for contour curves}
  \item{cex,pch,xlabs,ylabs,zlabs,add}{usual graphics parameters}
  \item{theta,phi,d}{graphics parameters for perspective plots}
  \item{drawlabels}{if TRUE then draw contour labels}
  \item{points.diff}{not currently implemented}
  \item{colors}{vector of colours for each contour (3-d plot)}
  \item{origin}{origin vector (3-d plot)}
  \item{endpts}{vector of end points for each of the 3 axes (3-d plot)}
  \item{alphavec}{vector of transparency values (3-d plot)}
  \item{size}{size of plotting symbol (3-d plot)}
  \item{...}{other graphics parameters}
}
  

\value{
  Plot of 2-d kernel density estimate is sent to graphics window. Plot
  for 3-d is generated by the \code{misc3d} and \code{rgl}
  libraries and is sent to RGL window.
}

\references{
  Bowman, A.W. & Azzalini, A. (1997) \emph{Applied Smoothing Techniques
    for Data Analysis}. Clarendon Press. Oxford.
  
  Simonoff, J. S., (1996) \emph{Smoothing Methods in Statistics}.
  Springer-Verlag. New York.}
}

\details{  
  There are three types of plotting displays for 2-d data available, controlled
  by the \code{display} parameter.

  If \code{display="slice"} then a slice/contour plot
  is generated using \code{contour}.
  The default contours are at 25\%, 50\%, 75\% or
  \code{cont=c(25,50,75)}.  The user can also set the number of contour
  level curves by changing the value set to \code{ncont}. See examples below.
  
  If \code{display="persp"} then a perspective/wire-frame plot
  is generated.  The default z-axis limits \code{zlim} are determined by
  the range of the z values i.e. default from the usual \code{persp} command.
  
  If \code{display="image"} then an image plot
  is generated. The colors are the default from the usual
  \code{image} command.

  For 3-dimensional data, the interactive plot is a series of nested 3-d contours.
  The default contours are \code{cont=c(25,50,75)}, the
  default \code{colors} are \code{heat.colors} and the
  default opacity \code{alphavec} ranges from 0.1 to 0.5.
  \code{origin} is the point where
  the three axes meet. \code{endpts} is the vector of the 
  maximum axis values to be plotted.  Default \code{endpts} is the
  maxima for the plotting grid from \code{x} (automatically generated by
  \code{\link{kde}}). 
}
 

\seealso{\code{\link{kde}}}

\examples{
## bivariate example
data(unicef)
H.scv <- Hscv(unicef)
fhat <- kde(unicef, H.scv)

layout(rbind(c(1,2), c(3,4)))
plot(fhat, display="slice", cont=seq(10,90, by=20), cex=0.3)
plot(fhat, display="slice", ncont=5, cex=0.3, drawlabels=FALSE)
plot(fhat, display="persp")
plot(fhat, display="image", col=rev(heat.colors(15)))
layout(1)

## trivariate example
\dontrun{
mus <- rbind(c(0,0,0), c(-1,1,1))
Sigma <- matrix(c(1, 0.7, 0.7, 0.7, 1, 0.7, 0.7, 0.7, 1), nr=3, nc=3) 
Sigmas <- rbind(Sigma, Sigma)
props <- c(1/2, 1/2)
x <- rmvnorm.mixt(n=100, mus=mus, Sigmas=Sigmas, props=props)
H.pi <- Hpi(x)
fhat <- kde(x, H.pi)  
plot(fhat, origin=c(-3,-3,-3))
}
}
\keyword{ hplot}
