% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{logsmoo}
\alias{logsmoo}
\title{Logarithmic smoothing with loess}
\usage{
logsmoo(x, y, x.is.log = FALSE, ...)
}
\arguments{
\item{x}{numeric; the index series (cannot contain \code{NA})}

\item{y}{numeric; the series of values associated with x}

\item{x.is.log}{logical; determines whether the series in \code{x} has
been log-transformed already. If \code{FALSE} then \code{log10} is used.}

\item{...}{additional parameters (e.g., \code{span}) passed to \code{\link{loess.smooth}}}
}
\value{
The result of \code{\link{loess.smooth}}
}
\description{
Logarithmic smoothing with loess
}
\examples{
set.seed(11133)
n <- 101
lx <- seq(-1,1,length.out=n)
y <- rnorm(n) + cumsum(rnorm(n))
plot(lx, y, col='grey')
lines(logsmoo(lx, y, x.is.log=TRUE))

}
\references{
Barbour, A. J., and D. C. Agnew (2011), Noise levels on 
Plate Boundary Observatory borehole strainmeters in southern California,
Bulletin of the Seismological Society of America, 101(5), 2453-2466,
doi: 10.1785/0120110062
}
\seealso{
\code{\link{loess.smooth}} and \code{\link{approxfun}}
}
