\name{open_well_response}
\alias{open_well_response}
\alias{open_well_response.default}
\title{Spectral response for an open well}
\usage{
  open_well_response(omega, T., S.,
    Rs. = (8/12) * (1200/3937), rho, grav, z, Hw, Ta,
    freq.units = c("rad_per_sec", "Hz"),
    model = c("rojstaczer", "liu", "cooper", "hsieh"),
    as.pressure = TRUE)

  \method{open_well_response}{default} (omega, T., S.,
    Rs. = (8/12) * (1200/3937), rho, grav, z, Hw, Ta,
    freq.units = c("rad_per_sec", "Hz"),
    model = c("rojstaczer", "liu", "cooper", "hsieh"),
    as.pressure = TRUE)
}
\arguments{
  \item{omega}{numeric; frequency, (see \code{freq.units})}

  \item{T.}{numeric; effective aquifer transmissivity
  \eqn{[m^2/s]}}

  \item{S.}{numeric; well storativity, \eqn{[unitless]}}

  \item{Rs.}{numeric; the \emph{radius} of the open
  (screened) section}

  \item{rho}{numeric; fluid density (assumed if missing)}

  \item{grav}{numeric; the local gravitational acceleration
  (assumed if missing)}

  \item{z}{numeric; From Rojstaczer (1988): the depth from
  the water table (assumed if missing and if needed)}

  \item{Hw}{numeric; height of water column above confined
  surface (assumed if missing and if needed)}

  \item{Ta}{numeric; thickness of aquifer (assumed if
  missing and if needed)}

  \item{freq.units}{character; setup the units of
  \code{omega}}

  \item{model}{character; use the response model from
  either Rojstaczer (1988), Liu et al (1989), Cooper et al
  (1965), or Hsieh et al (1987).}

  \item{as.pressure}{logical; should the response be
  relative to aquifer pressure? (default is aquifer head)}
}
\value{
  An object with class 'owrsp'
}
\description{
  This is the primary function to calculate the response
  for an open (exposed to air) well.
}
\details{
  As opposed to \code{\link{well_response}}, this
  calculates the theoretical, complex well response for an
  unsealed (open) well.

  The response depends strongly on the physical properties
  given. Default values are assumed where reasonable--for
  instance, the pore-fluid is assumed to be water--but
  considerable care should be invested in the choice of
  parameters, unless the function is used in an
  optimization scheme.

  The responses returned here are, effectively, the
  amplification of water levels in a well, relative to the
  pressure head in the aquifer; or \deqn{Z = \frac{z}{h}
  \equiv \frac{\rho g z}{p}} If \code{as.pressure=TRUE},
  then the responses are scaled by \code{rho*grav} so that
  they represent water levels relative to aquifer pressure:
  \deqn{Z = \frac{z}{p}}

  Not all parameters need to be given, but should be. For
  example, if either \code{rho} or \code{grav} are not
  specified, they are taken from \code{\link{constants}}.
  \emph{Parameters which do not end in \code{.} do not need
  to be specified (they may be excluded); if they are
  missing, warnings will be thrown.}
}
\section{Models}{
  \subsection{\code{"rojstaczer"}}{ Rojstaczer (1988) is
  based on measurements of water level and strain from
  volumetric or areal strainmeters. }
  \subsection{\code{"cooper"}, \code{"hsieh"}, and
  \code{"liu"}}{ Cooper et al (1965), Hsieh et al (1987)
  and Liu et al (1989) are based on measurements of water
  level and displacements from seismometers; these models
  are expressed succinctly in Roeloffs (1996).

  The sense of the phase shift for the Liu and Rojstaczer
  models are reversed from their original presentation, in
  order to account for differences in sign convention. }
}
\examples{
OWR <- open_well_response(1:10,1,1)
plot(OWR)
OWR <- open_well_response(1/(1:200),1,1,Ta=100,Hw=10,model="liu",freq.units="Hz")
plot(OWR)
}
\author{
  A. J. Barbour <andy.barbour@gmail.com>
}
\seealso{
  \code{\link{owrsp-methods}} for a description of the
  class 'owrsp' and its methods, and
  \code{\link{kitagawa-package}} for references and more
  background.

  Other WellResponseFunctions: \code{\link{well_response}},
  \code{\link{well_response.default}}
}

