% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kexpmv.R
\name{crs2mat}
\alias{crs2mat}
\title{Convert a CRS-formatted matrix to standard square format}
\usage{
crs2mat(mat, n)
}
\arguments{
\item{mat}{a 3 column list including the vectors; ia, ja and a.}

\item{n}{the dimension of the square (nxn) matrix.}
}
\description{
The \code{EXPOKIT}'s DMEPXV and DGEXPV functions both deal with sparse matrices.
These matrices have a lot of zeros, and can therefore be stored more efficiently by converting the
matrix into CRS (Compressed Row Storage) format.\cr
}
\details{
In \code{EXPOKIT} and its wrapper functions, a CRS-formatted matrix is input as
3 vectors: \cr

ia = row pointer. This vector stores the location in the `a' vector that is the first non-zero element 
in a row. \cr
ja = column indices for non-zero elements.\cr
a = non-zero elements of the matrix.\cr

This function takes a 3-column list CRS matrix and converts it back to standard square format.\cr
}
\examples{
# Create a CRS format matrix
ia = c(1, 2, 4, 6)
ja = c(1, 1, 2, 1, 2)
a  = c(-0.071207,  0.065573, -0.041206,  0.005634,  0.041206)
crsmat=list(ia, ja, a)

# Convert CRS format matrix to square format
n = 3
mat = crs2mat(crsmat, n)
print(mat)

}
\author{
Meabh G. McCurdy \email{mmccurdy01@qub.ac.uk}
}
