% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Laplace}
\alias{Laplace}
\title{Laplacian kernel}
\usage{
Laplace(X, g = NULL)
}
\arguments{
\item{X}{Matrix or data.frame that contains real numbers ("integer", "float" or "double").}

\item{g}{Gamma hyperparameter. If g=0 or NULL, `Laplace()` returns the Manhattan distance
(L1 norm between two vectors).}
}
\value{
Kernel matrix (dimension: \emph{NxN}).
}
\description{
`Laplace()` computes the laplacian kernel between all possible pairs of rows of a
matrix or data.frame with dimension \emph{NxD}.
}
\details{
Let \eqn{x_i,x_j} be two real vectors. Then, the laplacian kernel is defined as:
\deqn{K_{Lapl}(x_i,x_j)=\exp(-\gamma \|x_i - x_j \|_1)}
}
\examples{
dat <- matrix(rnorm(250),ncol=50,nrow=5)
Laplace(dat,g=0.1)
}
