% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{Boots_CI}
\alias{Boots_CI}
\title{Confidence Interval using Bootstrap}
\usage{
Boots_CI(target, pred, index = "acc", nboots, confidence = 95, ...)
}
\arguments{
\item{target}{Numeric vector containing the actual values.}

\item{pred}{Numeric vector containing the predicted values.
(The order should be the same than the target's).}

\item{index}{Performance measure name, in lowercase. (Defaults: "acc").}

\item{nboots}{Number of bootstrapping replicas.}

\item{confidence}{Confidence level; for instance, 95\% or 99\%. (Defaults: 95).}

\item{...}{Further arguments to be passed to the performance measures functions;
notably, multi.class="macro" or multi.class="micro" for the macro or micro
performance measures. (Defaults: "macro").}
}
\value{
A vector containing the bootstrap estimate of the performance and its CI.
}
\description{
`Boots_CI()` computes the Confidence Interval (CI) of a performance measure
(for instance, accuracy) via bootstrapping.
}
\examples{
y <- c(rep("a",30),rep("b",20))
y_pred <- c(rep("a",20),rep("b",30))
# Computing Accuracy with their 95\%CI
Boots_CI(target=y, pred=y_pred, index="acc", nboots=1000, confidence=95)
}
