% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens.direct.R
\name{dens.direct}
\alias{dens.direct}
\title{Direct estimation of non-separable adaptive spatio-temporal intensity estimator}
\usage{
dens.direct(
  X,
  t = NULL,
  dimyx = 128,
  dimt = 128,
  bw.xy = NULL,
  bw.t = NULL,
  at = c("bins", "points")
)
}
\arguments{
\item{X}{A spatial point pattern (an object of class \code{ppp}) with the spatial coordinates of the observations. It may contain marks representing times.}

\item{t}{A numeric vector of temporal coordinates with equal length to the number of points in \code{X}. This gives the time associated with each spatial point. This argument is not necessary if time marks are provided to the point pattern \code{X}.}

\item{dimyx}{Spatial pixel resolution. The default is 128 for each axes.}

\item{dimt}{Temporal bin vector dimension. The default is 128.}

\item{bw.xy}{Numeric vector of spatial smoothing bandwidths for each point in \code{X}. By default this is computed using \link[spatstat.explore]{bw.abram}, with \code{h0} given by \link[sparr]{OS}.}

\item{bw.t}{Numeric vector of temporal smoothing bandwidths for each point in \code{t}. By default this is computed using \link{bw.abram.temp}.}

\item{at}{String specifying whether to estimate the intensity at a mesh (\code{at = "bins"}) or only at the points of \code{X} (\code{at = "points"}).}
}
\value{
If \code{at = "points"} (the default), the result is a numeric vector with one entry for each data point in \code{X}. if \code{at = "bins"} is a list named (by time-point) list of pixel images (\link[spatstat.geom]{im} objects) corresponding to the joint spatio-temporal intensity over space at each discretised time bin.
}
\description{
Provides an adaptive-bandwidth kernel estimate for spatio-temporal point patterns in a non-separable fashion by calculating the classical estimator, i.e., the slowest estimation.
}
\details{
This function computes a non-separable spatio-temporal adaptive kernel estimate of the intensity. It starts from a planar point pattern \code{X} and a vector of times \code{t} and apply a non-separable kernel estimator for each of the points of \code{X}. The arguments \code{bw.xy} and \code{bw.t} specify the smoothing bandwidth vectors to be applied to each of the points in \code{X} and \code{t}. They should be a numeric vectors of bandwidths.
}
\examples{
data(lGCpp)
X <- lGCpp[sample.int(200)] # A random subset
stIntensity <- dens.direct(X, dimyx = 16, dimt = 4)
plot(spatstat.geom::as.solist(stIntensity), ncols = 4,
     main = 'Non-separable direct example', equal.ribbon = TRUE)

\donttest{
data(aegiss)
X <- aegiss[sample.int(500)] # A random subset
stIntensity <- dens.direct(X,
                           dimyx = 32, dimt = 16,
                           at = "bins")
plot(spatstat.geom::as.imlist(stIntensity[12:15]),
     main = 'Non-separable direct example')
}

}
\references{
González J.A. and Moraga P. (2018)
An adaptive kernel estimator for the intensity function of spatio-temporal point processes
\url{https://arxiv.org/pdf/2208.12026.pdf}
}
\author{
Jonatan A. González
}
