% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builtin_starts_estimation.R
\name{mlweibull}
\alias{mlweibull}
\title{Estimates the parameter of a Weibull distribution by maximum likelihood}
\usage{
mlweibull(x, shape0 = 2, rel.tol = .Machine$double.eps^0.25,
  iterlim = 100)
}
\arguments{
\item{x}{The data from which the estimate is to be computed.}

\item{shape0}{An optional starting value for the \code{shape} parameter.}

\item{rel.tol}{Relative accuracy requested.}

\item{iterlim}{A positive integer specifying the maximum number of
iterations to be performed before the program is terminated.}
}
\value{
A named numeric vector with maximum likelihood estimates for
\code{shape} and \code{scale}.
}
\description{
Uses Newton-Raphson to estimate the parameters of the Weibull distribution.
}
\keyword{internal}
