% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MeanDate-class}
\alias{MeanDate-class}
\alias{.MeanDate}
\title{Mean Date}
\description{
An S4 class to store the weighted mean date (e.g. Mean Ceramic Date) of
archaeological assemblages.
}
\section{Slots}{

\describe{
\item{\code{dates}}{A length-\eqn{p} \code{\link{numeric}} vector giving the dates of the
(ceramic) types expressed in \emph{\link[aion:RataDie-class]{rata die}}.}

\item{\code{replications}}{A \code{numeric} \code{\link{matrix}} giving the replications.}
}}

\note{
This class inherits from \code{\link[aion:TimeSeries-class]{aion::TimeSeries}}: dates are internally
stored as \emph{\link[aion:RataDie-class]{rata die}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{MeanDate} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
\code{\link[aion:TimeSeries-class]{aion::TimeSeries}}

Other classes: 
\code{\link{AoristicSum-class}},
\code{\link{CountApportion-class}},
\code{\link{EventDate-class}},
\code{\link{IncrementTest-class}},
\code{\link{PermutationOrder-class}},
\code{\link{RateOfChange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
