% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriate_average.R
\docType{methods}
\name{seriate_average}
\alias{seriate_average}
\alias{seriate_average-method}
\alias{seriate_average,data.frame-method}
\alias{seriate_average,matrix-method}
\title{Correspondence Analysis-Based Seriation}
\usage{
seriate_average(object, ...)

\S4method{seriate_average}{data.frame}(object, margin = c(1, 2), axes = 1, ...)

\S4method{seriate_average}{matrix}(object, margin = c(1, 2), axes = 1, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the
rearrangement will be applied over: \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows then columns, \code{c(2, 1)} indicates columns
then rows.}

\item{axes}{An \code{\link{integer}} vector giving the subscripts of the CA axes to be
used.}
}
\value{
An \code{\linkS4class{AveragePermutationOrder}} object.
}
\description{
Correspondence Analysis-Based Seriation
}
\details{
Correspondence analysis (CA) is an effective method for the seriation of
archaeological assemblages. The order of the rows and columns is given by
the coordinates along one dimension of the CA space, assumed to account for
temporal variation. The direction of temporal change within the
correspondence analysis space is arbitrary: additional information is needed
to determine the actual order in time.
}
\examples{
## Replicates Desachy 2004 results
data("compiegne", package = "folio")

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(indices <- seriate_rank(compiegne, EPPM = TRUE, margin = 2))

## Get permutation order
get_order(indices, 1) # rows
get_order(indices, 2) # columns

## Permute columns
(new <- permute(compiegne, indices))

## See the vignette
\dontrun{
utils::vignette("seriation")
}
}
\references{
Ihm, P. (2005). A Contribution to the History of Seriation in Archaeology.
In C. Weihs & W. Gaul (Eds.), \emph{Classification: The Ubiquitous
Challenge}. Berlin Heidelberg: Springer, p. 307-316.
\doi{10.1007/3-540-28084-7_34}.
}
\seealso{
\code{\link[dimensio:ca]{dimensio::ca()}}

Other seriation methods: 
\code{\link{permute}()},
\code{\link{seriate_rank}()},
\code{\link{seriate_refine}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
