% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_plot.R
\docType{methods}
\name{plot_event}
\alias{plot_event}
\alias{plot,EventDate,missing-method}
\title{Event Plot}
\usage{
\S4method{plot}{EventDate,missing}(
  x,
  type = c("activity", "tempo"),
  event = FALSE,
  calendar = getOption("kairos.calendar"),
  select = 1,
  n = 500,
  eps = 1e-09,
  flip = FALSE,
  ncol = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  ...
)
}
\arguments{
\item{x}{An \code{\linkS4class{EventDate}} object.}

\item{type}{A \code{\link{character}} string indicating the type of plot.
It must be one of "\code{activity}" (default) or "\code{tempo}".
Any unambiguous substring can be given.}

\item{event}{A \code{\link{logical}} scalar: should the distribution of the event date
be displayed? Only used if type is "\code{activity}".}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[aion:calendar]{calendar()}}).}

\item{select}{A \code{\link{numeric}} or \code{\link{character}} vector giving the selection of
the assemblage that are drawn.}

\item{n}{A length-one non-negative \code{\link{numeric}} vector giving the desired
length of the vector of quantiles for density computation.}

\item{eps}{A length-one \code{\link{numeric}} value giving the cutoff below which
values will be removed.}

\item{flip}{A \code{\link{logical}} scalar: should the y-axis (ticks and numbering) be
flipped from side 2 (left) to 4 (right) from series to series when \code{facet}
is "\code{multiple}"?}

\item{ncol}{An \code{\link{integer}} specifying the number of columns to use when
\code{facet} is "\code{multiple}". Defaults to 1 for up to 4 series, otherwise to 2.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{...}{Further parameters to be passed to \code{panel}
(e.g. \link[graphics:par]{graphical parameters}).}
}
\value{
\code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
Produces an activity or a tempo plot.
}
\section{Event and Acccumulation Dates}{

\code{plot()} displays the probability estimate density curves of archaeological
assemblage dates (\emph{event} and \emph{accumulation} dates; Bellanger and Husi
2012). The \emph{event} date is plotted as a line, while the \emph{accumulation} date
is shown as a grey filled area.

The accumulation date can be displayed as a tempo plot (Dye 2016) or an
activity plot (Philippe and Vibet 2020):
\describe{
\item{Tempo plot}{A tempo plot estimates the cumulative occurrence of
archaeological events, such as the slope of the plot directly reflects the
pace of change.}
\item{Activity plot}{An activity plot displays the first derivative of the
tempo plot.}
}
}

\examples{
\dontrun{
utils::vignette("event")
}
}
\references{
Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
Archaeological Science}, 39(4), 777-790. \doi{10.1016/j.jas.2011.06.031}.

Dye, T. S. (2016). Long-Term Rhythms in the Development of Hawaiian
Social Stratification. \emph{Journal of Archaeological Science}, 71, 1-9.
\doi{10.1016/j.jas.2016.05.006}.

Philippe, A. & Vibet, M.-A. (2020). Analysis of Archaeological Phases Using
the R Package ArchaeoPhases. \emph{Journal of Statistical Software, Code
Snippets}, 93(1), 1-25. \doi{10.18637/jss.v093.c01}.
}
\seealso{
\code{\link[=event]{event()}}

\code{\link[=event]{event()}}

Other plotting methods: 
\code{\link{plot_aoristic}},
\code{\link{plot_fit}},
\code{\link{plot_mcd}},
\code{\link{plot_time}()}
}
\author{
N. Frerebeau
}
\concept{plotting methods}
