% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_gamma.R
\name{Gamma}
\alias{Gamma}
\title{Gamma outcome for kDGLM models}
\usage{
Gamma(
  phi = NA,
  mu = NA,
  alpha = NA,
  beta = NA,
  sigma = NA,
  data,
  offset = as.matrix(data)^0
)
}
\arguments{
\item{phi}{character or numeric: Name of the linear predictor associated with the shape parameter of the gamma distribution. If numeric, this parameter is treated as known and equal to the value passed. If a character, the parameter is treated as unknown and equal to the exponential of the associated linear predictor. It cannot be specified with alpha.}

\item{mu}{character: Name of the linear predictor associated with the mean parameter of the gamma distribution. The parameter is treated as unknown and equal to the exponential of the associated linear predictor.}

\item{alpha}{character: Name of the linear predictor associated with the shape parameter of the gamma distribution. The parameter is treated as unknown and equal to the exponential of the associated linear predictor. It cannot be specified with phi.}

\item{beta}{character: Name of the linear predictor associated with the rate parameter of the gamma distribution. The parameter is treated as unknown and equal to the exponential of the associated linear predictor. It cannot be specified with sigma.}

\item{sigma}{character: Name of the linear predictor associated with the scale parameter of the gamma distribution. The parameter is treated as unknown and equal to the exponential of the associated linear predictor. It cannot be specified with beta.}

\item{data}{numeric: Values of the observed data.}

\item{offset}{numeric: The offset at each observation. Must have the same shape as data.}
}
\value{
An object of the class dlm_distr
}
\description{
Creates an outcome with gamma distribution with the chosen parameters (can only specify 2).
}
\details{
For evaluating the posterior parameters, we use the method proposed in \insertCite{ArtigokParametrico;textual}{kDGLM}.

For the details about the implementation see  \insertCite{ArtigoPacote;textual}{kDGLM}.
}
\examples{

structure <- polynomial_block(mu = 1, D = 0.95)

outcome <- Gamma(phi = 0.5, mu = "mu", data = cornWheat$corn.log.return[1:500]**2)
fitted.data <- fit_model(structure, corn = outcome)
summary(fitted.data)
plot(fitted.data, plot.pkg = "base")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fit_model}}

Other auxiliary functions for a creating outcomes: 
\code{\link{Multinom}()},
\code{\link{Normal}()},
\code{\link{Poisson}()},
\code{\link{summary.dlm_distr}()}
}
\concept{auxiliary functions for a creating outcomes}
