% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ.R
\name{summ.svyglm}
\alias{summ.svyglm}
\alias{j_summ.svyglm}
\title{Complex survey regression summaries with options}
\usage{
\method{summ}{svyglm}(model, scale = FALSE, vifs = FALSE, confint = FALSE,
  ci.width = 0.95, digits = getOption("jtools-digits", default = 2),
  model.info = TRUE, model.fit = TRUE, model.check = FALSE,
  pvals = TRUE, n.sd = 1, center = FALSE, scale.response = FALSE,
  odds.ratio = FALSE, ...)
}
\arguments{
\item{model}{A \code{svyglm} object.}

\item{scale}{If \code{TRUE}, reports standardized regression
coefficients. Default is \code{FALSE}.}

\item{vifs}{If \code{TRUE}, adds a column to output with variance inflation
factors (VIF). Default is \code{FALSE}.}

\item{confint}{Show confidence intervals instead of standard errors? Default
is \code{FALSE}.}

\item{ci.width}{A number between 0 and 1 that signifies the width of the
desired confidence interval. Default is \code{.95}, which corresponds
to a 95\% confidence interval. Ignored if \code{confint = FALSE}.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired
number.}

\item{model.info}{Toggles printing of basic information on sample size,
name of DV, and number of predictors.}

\item{model.fit}{Toggles printing of R-squared and adjusted R-squared.}

\item{model.check}{Toggles whether to perform Breusch-Pagan test for
heteroskedasticity
and print number of high-leverage observations. See details for more info.}

\item{pvals}{Show p values and significance stars? If \code{FALSE}, these
are not printed. Default is \code{TRUE}, except for merMod objects (see
details).}

\item{n.sd}{If \code{scale = TRUE}, how many standard deviations should
predictors be divided by? Default is 1, though some suggest 2.}

\item{center}{If you want coefficients for mean-centered variables but don't
want to standardize, set this to \code{TRUE}.}

\item{scale.response}{Should standardization apply to response variable?
Default is \code{FALSE}.}

\item{odds.ratio}{If \code{TRUE}, reports exponentiated coefficients with
confidence intervals for exponential models like logit and Poisson models.
This quantity is known as an odds ratio for binary outcomes and incidence
rate ratio for count models.}

\item{...}{This just captures extra arguments that may only work for other
types of models.}
}
\value{
If saved, users can access most of the items that are returned in the
output (and without rounding).

\item{coeftable}{The outputted table of variables and coefficients}
\item{model}{The model for which statistics are displayed. This would be
most useful in cases in which \code{scale = TRUE}.}

Much other information can be accessed as attributes.
}
\description{
\code{summ} prints output for a regression model in a fashion similar to
\code{summary}, but formatted differently with more options.
}
\details{
By default, this function will print the following items to the
console:
\itemize{
\item The sample size
\item The name of the outcome variable
\item The (Pseudo-)R-squared value and AIC.
\item A table with regression coefficients, standard errors, t-values, and
p values.
}

The \code{scale} and \code{center} options are performed via refitting
the model with \code{\link{scale_lm}} and \code{\link{center_lm}},
respectively. Each of those in turn uses \code{\link{gscale}} for the
mean-centering and scaling. These functions can handle \code{svyglm} objects
correctly by calling \code{svymean} and \code{svyvar} to compute means and
standard deviations. Weights are not altered. The fact that the model is
refit means the runtime will be similar to the original time it took to fit
the model.
}
\examples{
if (requireNamespace("survey")) {
  library(survey)
  data(api)
  dstrat <- svydesign(id = ~1, strata =~ stype, weights =~ pw,
                      data = apistrat, fpc =~ fpc)
  regmodel <- svyglm(api00 ~ ell * meals, design = dstrat)

  summ(regmodel)
}
}
\seealso{
\code{\link{scale_lm}} can simply perform the standardization if
preferred.

\code{\link{gscale}} does the heavy lifting for mean-centering and scaling
behind the scenes.
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
