% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{json_flatten}
\alias{json_flatten}
\title{Flatten a JSON array}
\usage{
json_flatten(
  x,
  ptype = NULL,
  allow_scalars = FALSE,
  wrap_scalars = FALSE,
  bigint_as_char = bigint_default()
)
}
\arguments{
\item{x}{A JSON vector.}

\item{ptype}{Output type. If \code{NULL}, the default, the output type is
determined by computing the common type across all elements. Use
\code{new_json_array()} resp. \code{new_json_object()} if you know every element is
an array resp. object. Mind that the return type will only be \code{json2}.}

\item{allow_scalars}{Do not error for scalar elements?}

\item{wrap_scalars}{Should scalar values be wrapped?
Note that scalars are only wrapped if either
\itemize{
\item \code{ptype} is \code{new_json_array()} or \code{json2} vector.
\item \code{ptype} is \code{NULL} and the elements are a mix of scalar values and arrays.
}}

\item{bigint_as_char}{Convert big integers to character? The option
\code{jsontools.bigint_as_char} is used as default.}
}
\value{
A flattened version of \code{x} with class given by \code{ptype} and length
equal to the sum of the \code{json_array_length()} of the components of \code{x}.
}
\description{
Flatten a JSON array
}
\examples{
json_flatten(c("[1, 2]", "[3]"))

# names are kep
json_flatten(c(x = "[1, 2]", y = "[3]"))

# scalar elements produce an error ...
try(json_flatten(c(x = "[1, 2]", y = "3")))
# ... but can be explicitly allowed with `allow_scalars`
json_flatten(c(x = "[1, 2]", y = "3"), allow_scalars = TRUE)
}
\seealso{
\code{\link[=json_unnest_longer]{json_unnest_longer()}}, \code{\link[=json_unnest_wider]{json_unnest_wider()}}
}
