% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleData.R
\name{sampleData}
\alias{sampleData}
\title{Sample from an \code{mjoint} object}
\usage{
sampleData(object, size = NULL, replace = TRUE)
}
\arguments{
\item{object}{an object inheriting from class \code{mjoint} for a joint model
of time-to-event and multivariate longitudinal data.}

\item{size}{number of subjects to include in the sampled subset. If
\code{size=NULL} (default), then size is set equal to the number of
subjects used to fit the \code{mjoint} model.}

\item{replace}{use replacement when sampling subjects? Default is
\code{TRUE}. If replacement is used, then the subjects are re-labelled from
1 to \code{size}.}
}
\value{
A list of 2 data.frames: one recording the requisite longitudinal
  outcomes data, and the other recording the time-to-event data.
}
\description{
Generic function used to sample a subset of data from an object
  of class \code{mjoint} with a specific number of subjects.
}
\details{
This function is primarily intended for internal use in the
  \code{\link{bootSE}} function in order to permit bootstrapping. However, it
  can be used for other purposes given a fitted \code{mjoint} object.
}
\examples{
\dontrun{
# Fit a joint model with bivariate longitudinal outcomes

data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]

fit2 <- mjoint(
    formLongFixed = list("grad" = log.grad ~ time + sex + hs,
                         "lvmi" = log.lvmi ~ time + sex),
    formLongRandom = list("grad" = ~ 1 | num,
                          "lvmi" = ~ time | num),
    formSurv = Surv(fuyrs, status) ~ age,
    data = list(hvd, hvd),
    inits = list("gamma" = c(0.11, 1.51, 0.80)),
    timeVar = "time",
    verbose = TRUE)
sampleData(fit2, size = 10)
}
}
\seealso{
\code{\link{mjoint}}.
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{datagen}
\keyword{methods}
\keyword{multivariate}
\keyword{survival}
