% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcdpmeta.R
\name{bcdpmeta}
\alias{bcdpmeta}
\title{Bias Corrected Meta-Analysis with Dirichlet Process Priors}
\usage{
bcdpmeta(
  data,
  mean.mu.0 = 0,
  sd.mu.0 = 10,
  scale.sigma.between = 0.5,
  df.scale.between = 1,
  B.lower = 0,
  B.upper = 10,
  a.0 = 1,
  a.1 = 1,
  alpha.0 = 0.03,
  alpha.1 = 10,
  K = 30,
  nr.chains = 2,
  nr.iterations = 10000,
  nr.adapt = 1000,
  nr.burnin = 1000,
  nr.thin = 1,
  be.quiet = FALSE
)
}
\arguments{
\item{data}{A data frame with at least two columns with the following names:
1) TE = treatment effect,
2) seTE = the standard error of the treatment effect.}

\item{mean.mu.0}{Prior mean of the mean of the base distribution default value is mean.mu.0 = 0.}

\item{sd.mu.0}{Prior standard deviation of the base distribution, the default value is 10.}

\item{scale.sigma.between}{Prior scale parameter for scale gamma distribution for the
precision between studies. The default value is 0.5.}

\item{df.scale.between}{Degrees of freedom of the scale gamma distribution for the precision between studies.
The default value is 1, which results in a Half Cauchy distribution for the standard
deviation between studies. Larger values e.g. 30 corresponds to a Half Normal distribution.}

\item{B.lower}{Lower bound of the bias parameter B, the default value is 0.}

\item{B.upper}{Upper bound of the bias parameter B, the default value is 10.}

\item{a.0}{Parameter for the prior Beta distribution for the probability of bias. Default value is a0 = 1.}

\item{a.1}{Parameter for the prior Beta distribution for the probability of bias. Default value is a1 = 1.}

\item{alpha.0}{Lower bound of the uniform prior for the concentration parameter for the DPM,
default value is alpha.0 = 0.03.}

\item{alpha.1}{Upper bound of the uniform prior for the concentration parameter for the DPM,
default value is alpha.1 = 10.}

\item{K}{Maximum number of clusters in the DPM, default value is K = 30.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, default is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discard for burn-in period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{be.quiet}{Do not print warning message if the model does not adapt. The default value is FALSE. If you are not sure about the adaptation period choose be.quiet=TRUE.}
}
\value{
This function returns an object of the class "bcdpmeta". This object contains the MCMC
                           output of each parameter and hyper-parameter in the model and
                           the data frame used for fitting the model.
}
\description{
This function performers a Bayesian meta-analysis with DP as random effects
}
\details{
The results of the object of the class bcdpmeta can be extracted with R2jags or with rjags. In addition a summary, a print and a plot functions are
implemented for this type of object.
}
\examples{
\dontrun{
library(jarbes)


# Example: Stemcells

data("stemcells")
stemcells$TE = stemcells$effect.size
stemcells$seTE = stemcells$se.effect

bm1 = bcdpmeta(stemcells)
summary(bm1)

}

}
\references{
Verde, P.E. (2021) A Bias-Corrected Meta-Analysis Model for Combining Studies of Different Types and Quality. Biometrical Journal; 1–17.
}
