% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtr.R
\name{genGamma}
\alias{genGamma}
\title{Estimating expectations of terms in the MTR (gamma objects)}
\usage{
genGamma(monomials, lb, ub, multiplier = 1, subset = NULL,
  means = TRUE, late.rows = NULL)
}
\arguments{
\item{monomials}{[UPDATE DESCRIPTION] object containing list of
list of monomials. Each element of the outer list represents an
observation in the data set, each element in the inner list is
a monomial from the MTR. The variable is the unobservable u,
and the coefficient is the evaluation of any interactions with
u.}

\item{lb}{vector of lower bounds for the interval of
integration. Each element corresponds to an observation.}

\item{ub}{vector of upper bounds for the interval of
integration. Each element corresponds to an observation.}

\item{multiplier}{a vector of the weights that enter into the
integral. Each element corresponds to an observation.}

\item{subset}{The row names/numbers of the subset of observations
to use.}

\item{means}{logical, if TRUE then function returns the terms of
E[md]. If FALSE, then function instead returns each term of
E[md | D, X, Z]. This is useful for testing the code,
i.e. obtaining population estimates.}

\item{late.rows}{Boolean vector indicating which observations to
include when conditioning on covariates X.}
}
\value{
If \code{means = TRUE}, then the function returns a vector
    of the additive terms in Gamma (i.e. the expectation is over D,
    X, Z, and u). If \code{means = FALSE}, then the function
    returns a matrix, where each row corresponds to an observation,
    and each column corresponds to an additive term in E[md | D, X,
    Z] (i.e. only the integral with respect to u is performed).
}
\description{
This function generates the gamma objects defined in the paper,
i.e. each additive term in E[md], where md is a MTR.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare MTR formula
formula0 = ~ 1 + u

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                data = dtm,
                uname = u,
                as.function = FALSE)

## Construct propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate gamma moments, with S-weight equal to its default value
## of 1
genGamma(monomials = polynomials0,
         lb = 0,
         ub = propensityObj$phat)

}
