% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{boundCI}
\alias{boundCI}
\title{Construct confidence intervals for treatment effects under partial
identification}
\usage{
boundCI(bound, bound.resamples, n, m, levels, type)
}
\arguments{
\item{bound}{vector, bound of the treatment effects under partial
identification.}

\item{bound.resamples}{matrix, stacked bounds of the treatment
effects under partial identification. Each row corresponds to a
subset resampled from the original data set.}

\item{n}{integer, size of original data set.}

\item{m}{integer, size of resampled data sets.}

\item{levels}{vector, real numbers between 0 and 1. Values
correspond to the level of the confidence intervals constructed
via bootstrap.}

\item{type}{character. Set to 'forward' to construct the forward
confidence interval for the treatment effect bound. Set to
'backward' to construct the backward confidence interval for
the treatment effect bound. Set to 'both' to construct both
types of confidence intervals.}
}
\value{
if \code{type} is 'forward' or 'backward', then the
    corresponding type of confidence interval for each level is
    returned. The output is in the form of a matrix, with each row
    corresponding to a level. If \code{type} is 'both', then a list
    is returned. One element of the list is the matrix of backward
    confidence intervals, and the other element of the list is the
    matrix of forward confidence intervals.
}
\description{
This function constructs the forward and backward confidence
intervals for the treatment effect under partial identification.
}
