% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{calcularNotas}
\alias{calcularNotas}
\title{C\enc{á}{a}lculo de notas.}
\usage{
calcularNotas(puntajes, pjeMax = max(puntajes), notaMin = 1, notaMax = 7,
  notaAprob = 4, prema = 0.6)
}
\arguments{
\item{puntajes}{Un vector con los puntajes obtenidos por los estudiantes
en la prueba.}

\item{pjeMax}{El puntaje m\enc{á}{a}ximo posible de alcanzar en la prueba.}

\item{notaMin}{La nota m\enc{í}{i}nima otorgada al estudiante sin puntaje.}

\item{notaMax}{La nota m\enc{á}{a}xima otorgada al estudiante con mejor puntaje.}

\item{notaAprob}{La nota necesaria para aprobar la prueba.}

\item{prema}{Porcentaje de rendimiento m\enc{í}{i}nimo aceptable. Corresponde
a la proporci\enc{ó}{o}n del puntaje m\enc{á}{a}ximo necesario para obtener
la nota de aprobaci\enc{ó}{o} en la prueba.}
}
\value{
Un vector con las notas obtenidas por los estudiantes en la prueba.
}
\description{
Calcula la nota obtenida por cada estudiante en funci\enc{ó}{o}n de
su puntaje alcanzado en la prueba seg\enc{ú}{u}n el sistema de calificaci\enc{ó}{o}n
utilizado en Chile.
}
\examples{
data(datos)
data(clave)
respuestas <- subset(datos, select = -id)
puntajes <- calcularPuntajes(corregirItems(respuestas, clave))
notas <- calcularNotas(puntajes)
cbind(datos$id, pje=puntajes, nota=notas)

}
\seealso{
\code{\link{calcularPuntajes}} y \code{\link{corregirItems}}.
}
