% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{analizarDistractores}
\alias{analizarDistractores}
\title{An\enc{á}{a}lisis de distractores.}
\usage{
analizarDistractores(respuestas, clave, nOpciones = 4, proporcion = 0.27,
  frecuencia = TRUE, digitos = 2)
}
\arguments{
\item{respuestas}{Una matriz con las alternativas seleccionadas por los estudiantes
en cada \enc{í}{i}tem.}

\item{clave}{Una matriz con las alternativas correctas para cada \enc{í}{i}tem.}

\item{nOpciones}{La cantidad de alternativas posibles para cada \enc{í}{i}tem.}

\item{proporcion}{Proporción del total de estudiantes que contituyen los grupos superior e inferior.}

\item{frecuencia}{Un valor l\enc{ó}{o}gico para determinar si la
informaci\enc{ó}{o}n se presenta como frecuencia (TRUE) o proporci\enc{ó}{o}n (FALSE).}

\item{digitos}{La cantidad de d\enc{í}{i}gitos significativos que tendr\enc{á}{a} el resultado.}
}
\value{
Una lista en la cual cada elemento corresponde a un \enc{í}{i}tem.
Para cada \enc{í}{i}tem se calcula la frecuencia o proporci\enc{ó}{o}n de las
alternativas seleccionadas por el grupo superior y por el grupo inferior de estudiantes.
}
\description{
Calcula la frecuencia o proporci\enc{ó}{o}n de las alternativas
seleccionadas por el grupo superior e inferior en cada \enc{í}{i}tem.
}
\examples{
data(datos)
data(clave)
respuestas <- subset(datos, select = -id )
analizarDistractores(respuestas, clave)

}
\references{
Morales, P. (2009). An\enc{á}{a}lisis de \enc{í}{i}tem en las pruebas objetivas.
Madrid. Recuperado de \url{https://educrea.cl/wp-content/uploads/2014/11/19-nov-analisis-de-items-en-las-pruebas-objetivas.pdf}
}
\seealso{
\code{\link{frecuenciaDistractores}} y \code{\link{analizarItems}}.
}
