% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoread.R
\name{reread_iso_files}
\alias{reread_iso_files}
\title{Re-read iso_files}
\usage{
reread_iso_files(
  iso_files,
  ...,
  stop_if_missing = FALSE,
  reread_only_changed_files = FALSE,
  reread_only_outdated_files = FALSE,
  reread_files_without_problems = TRUE,
  reread_files_with_errors = TRUE,
  reread_files_with_warnings = TRUE,
  quiet = default(quiet)
)
}
\arguments{
\item{iso_files}{collection of iso_files}

\item{...}{additional read parameters that should be used for re-reading the iso_files, see \code{\link{iso_read_dual_inlet}}, \code{\link{iso_read_continuous_flow}} and \code{\link{iso_read_scan}} for details (except \code{read_cache} which is always set to \code{FALSE} to force re-reads).}

\item{stop_if_missing}{whether to stop re-reading if any of the original data files are missing (if FALSE, will warn about the missing files adding a warning to them, but also re-read those that do exist)}

\item{reread_only_changed_files}{whether to re-read only files that have since be changed on disc (i.e. have no valid cache file), default FALSE i.e. re-read ALL files}

\item{reread_only_outdated_files}{whether to re-read only files that were read by an outdated version of isoreader (default FALSE, i.e. re-read ALL files)}

\item{reread_files_without_problems}{whether to re-read files that had read in without problems the last time (default TRUE)}

\item{reread_files_with_errors}{whether to re-read files that had read in with errors the last time (default TRUE)}

\item{reread_files_with_warnings}{whether to re-read files that had read in with warnings the last time (default TRUE)}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_messages_on} and \link[=iso_info_messages]{iso_turn_info_messages_off}}
}
\description{
Actual multi-purpose file-reread function (not exported) that powers \link{iso_reread_files}.
}
