% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{iso_export_to_excel}
\alias{iso_export_to_excel}
\title{Export data to Excel}
\usage{
iso_export_to_excel(
  iso_files,
  filepath,
  include_file_info = everything(),
  include_raw_data = everything(),
  include_standards = !!enexpr(include_method_info),
  include_resistors = !!enquo(include_method_info),
  include_vendor_data_table = everything(),
  include_problems = everything(),
  with_explicit_units = FALSE,
  include_method_info = everything(),
  with_ratios = NULL,
  quiet = default(quiet)
)
}
\arguments{
\item{iso_files}{collection of iso_file objects}

\item{filepath}{the path (folder and filename) to the export file. The correct file extension is automatically added if not already in the filename, i.e. filename can be provided with or without extension.}

\item{include_file_info}{which file information to include (see \code{\link{iso_get_file_info}}). Use \code{c(...)} to select multiple, supports all \link[dplyr]{select} syntax including renaming columns.}

\item{include_raw_data}{which columns from the raw data to include. Use \code{c(...)} to select multiple columns, supports all \link[dplyr]{select} syntax including renaming columns. Includes all columns by default. Set to NULL to include no raw data.}

\item{include_standards}{which columns from the standards info to include. Use \code{c(...)} to select multiple columns, supports all \link[dplyr]{select} syntax including renaming columns. By default, everything is included (both standards and ratios). To omit the ratios, change to \code{select = file_id:reference}. Set to NULL to include no standards info.}

\item{include_resistors}{which columns from the resistors info to include. Use \code{c(...)} to select multiple columns, supports all \link[dplyr]{select} syntax including renaming columns. Includes all columns by default. Set to NULL to include no resistors info.}

\item{include_vendor_data_table}{which columns from the vendor data table to include. Use \code{c(...)} to select multiple columns, supports all \link[dplyr]{select} syntax including renaming columns. Includes all columns by default. Set parameter \code{with_explicit_units = TRUE} to make column units explicit (keep in mind that this will require specific \code{include_vendor_data_table} column selections to reflect the column names including the units). Set to NULL to include no vendor data table.}

\item{include_problems}{which columns from problems to include. Use \code{c(...)} to select multiple columns, supports all \link[dplyr]{select} syntax including renaming columns. Includes none of the read problems by default. Set to \code{include_problems = everything()} to include all columns.}

\item{with_explicit_units}{whether to include units in the column headers of the returned data frame instead of the column data types (see \code{\link{iso_double_with_units}}). Note that any \code{select} conditions have to refer to the column names including the full units.}

\item{include_method_info}{deprecated in favor of the more specific include_standards and include_resistors}

\item{with_ratios}{deprecated, please use the \code{select} parameter to explicitly include or exclude ratio columns}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_message_on} and \link[=iso_info_messages]{iso_turn_info_message_off}}
}
\value{
returns the iso_files object invisibly for use in pipelines
}
\description{
This function exports the passed in iso_files to Excel. The different kinds of data (raw data, file info, methods info, etc.) are exported to separate tabs within the excel file. Use the various \code{include_...} parameters to specify what information to include. Note that in rare instances where vectorized data columns exist in the file information (e.g. measurement_info), they are concatenated with ', ' in the excel export.
}
\seealso{
Other export functions: 
\code{\link{iso_export_to_feather}()},
\code{\link{iso_export_to_rda}()},
\code{\link{iso_save}()}
}
\concept{export functions}
