% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnvironmentalFit.R
\name{rates_calculator}
\alias{rates_calculator}
\title{Colonization and extinction rates calculator for expressions.}
\usage{
rates_calculator(params, exp1, exp2, t)
}
\arguments{
\item{params}{A vector with priors of the parameters in exp1 and exp2.}

\item{exp1}{Expression for colonization.}

\item{exp2}{Expression for extinction.}

\item{t}{Number of colonization and extinction pairs required.}
}
\value{
A matrix with the colonization and extinction rates.
}
\description{
\code{rates_calculator} Calculate colonization and extinction rates depending
of their expressions.
}
\examples{
rates_calculator(c(-0.00497925, -0.01729602, 0.19006501,
0.93486956), expression(params[1] * idaho[[2]]$TOTAL.ppt[i] + params[3]),
expression(params[2] * idaho[[2]]$ANNUAL.temp[i] + params[4]), 21)

}
\seealso{
\code{\link{all_environmental_fit}}
}
