% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_roll}
\alias{filter_roll}
\title{Filter with rolling median}
\usage{
filter_roll(DT, window = 3L, id = "id", method = "median")
}
\arguments{
\item{DT}{data.table of NDVI time series}

\item{window}{window size. default is 3.}

\item{id}{id column. default is 'id'. See details.}

\item{method}{median. no other options yet. let me know if you are looking for something else.}
}
\value{
filtered data.table with appended 'rolled' column of each id's rolling median, filtered NDVI time series.
}
\description{
Using a rolling median, filter the NDVI time series for each id.
}
\details{
The id argument is used to split between sampling units. This may be a point id, polygon id, pixel id, etc. depending on your analysis.
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file("extdata", "ndvi.csv", package = "irg"))

filter_qa(ndvi, qa = 'SummaryQA', good = c(0, 1))
filter_winter(ndvi, probs = 0.025, limits = c(60L, 300L), doy = 'DayOfYear', id = 'id')
filter_roll(ndvi, window = 3L, id = 'id')
}
\seealso{
Other filter: \code{\link{filter_ndvi}},
  \code{\link{filter_qa}}, \code{\link{filter_top}},
  \code{\link{filter_winter}}
}
\concept{filter}
