% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{iprCatmullRom}
\alias{iprCatmullRom}
\title{Catmull-Rom interpolator}
\usage{
iprCatmullRom(points, closed = FALSE, alpha = 0.5)
}
\arguments{
\item{points}{numeric matrix of 2D or 3D points, one point per row}

\item{closed}{Boolean, whether the curve is closed}

\item{alpha}{parameter between 0 and 1; the default value 0.5 is recommended}
}
\value{
An interpolator, for usage in \code{\link{evalInterpolator}}.
}
\description{
Catmull-Rom interpolator for 2-dimensional or 3-dimensional
  points.
}
\details{
See \href{https://www.boost.org/doc/libs/1_83_0/libs/math/doc/html/math_toolkit/catmull_rom.html}{Catmull-Rom splines}.
}
\examples{
library(interpolators)
points <- rbind(
  c(0, 2.5),
  c(2, 4),
  c(3, 2),
  c(4, 1.5),
  c(5, 6),
  c(6, 5),
  c(7, 3),
  c(9, 1),
  c(10, 2.5),
  c(11, 7),
  c(9, 5),
  c(8, 6),
  c(7, 5.5)
)
ipr <- iprCatmullRom(points)
s <- seq(0, 1, length.out = 400)
Curve <- evalInterpolator(ipr, s)
head(Curve)
plot(Curve, type = "l", lwd = 2)
points(points, pch = 19)

# a closed example (pentagram) ####
rho <- sqrt((5 - sqrt(5))/10)
R <- sqrt((25 - 11*sqrt(5))/10)
points <- matrix(NA_real_, nrow = 10L, ncol = 2L)
points[c(1, 3, 5, 7, 9), ] <- t(vapply(0:4, function(i){
  c(rho*cospi(2*i/5), rho*sinpi(2*i/5))
}, numeric(2L)))
points[c(2, 4, 6, 8, 10), ] <- t(vapply(0:4, function(i){
  c(R*cospi(2*i/5 + 1/5), R*sinpi(2*i/5 + 1/5))
}, numeric(2L)))
ipr <- iprCatmullRom(points, closed = TRUE)
s <- seq(0, 1, length.out = 400L)
Curve <- evalInterpolator(ipr, s)
plot(Curve, type = "l", lwd = 2, asp = 1)
points(points, pch = 19)
}
