% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-cmplx.r
\name{as_cmplx}
\alias{as_cmplx}
\alias{as_cmplx.default}
\alias{as_cmplx.Rcpp_SimplexTree}
\alias{as_cmplx.gudhi.simplex_tree.SimplexTree}
\alias{as_cmplx.igraph}
\alias{as_cmplx.network}
\title{Coerce objects to lists of simplices}
\usage{
as_cmplx(x, ...)

\method{as_cmplx}{default}(x, ...)

\method{as_cmplx}{Rcpp_SimplexTree}(x, ...)

\method{as_cmplx}{gudhi.simplex_tree.SimplexTree}(x, ...)

\method{as_cmplx}{igraph}(x, index = NULL, ...)

\method{as_cmplx}{network}(x, index = NULL, ...)
}
\arguments{
\item{x}{An R object to be coerced. See Details.}

\item{...}{Additional arguments passed to methods.}

\item{index}{Integer-valued vertex attribute to be used as 0-simplex indices.
Ignored if \code{NULL} (the default).}
}
\value{
A list of integer vectors, each encoding one simplex.
}
\description{
Coerce objects to lists of simplices, as used by
\link[TDA:TDA-package]{the TDA package}.
}
\details{
\code{as_cmplx()} is a generic function with specific methods for different
simplicial complex S3 classes. It returns a list of integer vectors, each of
which represents a simplex, and \emph{all} simplices are included in the list.
When a filtration is constructed using \verb{TDA::*Filtration()}, the first named
element of the returned list, \code{cmplx}, is a list whose \emph{i}th element
contains the vertices of the \emph{i}th simplex.
}
\examples{
# pick the simplicial complex from a TDA filtration object
t <- 2 * pi * c(0, 1, 3, 6) / 7
rf <- TDA::ripsFiltration(
  cbind(x = cos(t), y = sin(t)),
  maxdimension = 2L, maxscale = 1.7
)
print(rf$cmplx)
cp_rf <- as_cmplx(rf)
print(cp_rf)

# convert a simplextree object
st <- simplextree::simplex_tree()
st$insert(list(3:5, 5:6, 8))
cp_st <- as_cmplx(st)
print(cp_st)

\dontrun{

# convert a Python GUDHI simplex tree
gd <- reticulate::import("gudhi")
gd_st <- gd$SimplexTree()
for (s in list(3:5, 5:6, 8)) gd_st$insert(as.list(s))
cp_gd <- as_cmplx(gd_st)
print(cp_gd)
}

# convert an igraph object
ig <- igraph::graph(c(1,2, 2,3, 1,3, 3,4))
set.seed(0L)
ig <- igraph::set_vertex_attr(ig, "id", value = sample(igraph::vcount(ig)))
print(ig)
cp_ig <- as_cmplx(ig, index = "id")
print(cp_ig)

# convert a network object
el <- data.frame(tails = c(1, 2, 1, 3), heads = c(2, 3, 3, 4))
nw <- network::network.edgelist(el, network::network.initialize(4))
print(nw)
cp_nw <- as_cmplx(nw)
print(cp_nw)
}
