% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{capacity}
\alias{capacity}
\title{Scheduling interim analyses in clinical trials}
\usage{
capacity(nc, ns, sf)
}
\arguments{
\item{nc}{maximum number of centers to be opened.}

\item{ns}{maximum number of patients to be screened within each center.}

\item{sf}{screening failure rate.}
}
\value{
The maximum number of patients that can be enrolled.
}
\description{
Function \code{capacity} calculates the maximum number of enrollments for a recruitment in scenario 4.
}
\details{
\code{capacity} is an auxilliary function to determine the maximum number of patients that can be enrolled
in the scenario where only a limited number of centers is available and each center only has a limited number
of patients that can be enrolled.
}
\examples{
mE=capacity(nc=40,ns=10,sf=0.3)
recruitment(nc=40,ns=10,cw=4,sw=2,sf=0.3,tb=4,en=mE)
}
\seealso{
\code{\link{recruitment}} for simulating recruitment scenarios
}

