% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssmle_lt.R
\name{bssmle_lt}
\alias{bssmle_lt}
\title{B-spline Sieve Maximum Likelihood Estimation for Left-Truncated and Interval-Censored Competing Risks Data}
\usage{
bssmle_lt(formula, data, alpha, k = 1)
}
\arguments{
\item{formula}{a formula object relating survival object \code{Surv2(w, v, u, event)} to a set of covariates}

\item{data}{a data frame that includes the variables named in the formula argument}

\item{alpha}{\eqn{\alpha = (\alpha1, \alpha2)} contains parameters that define the link functions from class of generalized odds-rate transformation models. The components \eqn{\alpha1} and \eqn{\alpha2} should both be \eqn{\ge 0}. If \eqn{\alpha1 = 0}, the user assumes the proportional subdistribution hazards model or the Fine-Gray model for the event type 1. If \eqn{\alpha2 = 1}, the user assumes the proportional odds model for the event type 2.}

\item{k}{a parameter that controls the number of knots in the B-spline with \eqn{0.5 \le }\code{k}\eqn{ \le 1}}
}
\value{
The function \code{bssmle_lt} returns a list of components:
\item{beta}{a vector of the estimated coefficients}
\item{varnames}{a vector containing variable names}
\item{alpha}{a vector of the link function parameters}
\item{loglikelihood}{a loglikelihood of the fitted model}
\item{convergence}{an indicator of convegence}
\item{tms}{a vector of the minimum and maximum observation times}
\item{Z}{a design matrix}
\item{Tw}{a vector of \code{w}}
\item{Tv}{a vector of \code{v}}
\item{Tu}{a vector of \code{u}}
\item{Bw}{a list containing the B-splines basis functions evaluated at \code{w}}
\item{Bv}{a list containing the B-splines basis functions evaluated at \code{v}}
\item{Bu}{a list containing the B-splines basis functions evaluated at \code{u}}
\item{dBw}{a list containing the first derivative of B-splines basis functions evaluated at \code{w}}
\item{dBv}{a list containing the first derivative of B-splines basis functions evaluated at \code{v}}
\item{dBu}{a list containing the first derivative of B-splines basis functions evaluated at \code{u}}
\item{dmat}{a matrix of event indicators}
}
\description{
Routine that performs B-spline sieve maximum likelihood estimation with linear and nonlinear inequality constraints
}
\details{
The function \code{bssmle_lt} performs B-spline sieve maximum likelihood estimation for left-truncated and interval-censored competing risks data.
}
\author{
Giorgos Bakoyannis, \email{gbakogia at iu dot edu}

Jun Park, \email{jp84 at iu dot edu}
}
\keyword{bssmle_lt}
