\name{ssaOptim}
\alias{ssaOptim}
\title{ Spatial simulated annealing for optimized model based mapping}
\description{
nDiff measurement stations will be optimally 
Optimization of measurement network with Spatial simulated annealing and MUKV
}
\usage{
ssaOptim(observations, predGrid, candidates, action, nDiff, model,
nr_iterations, plotOptim, ...)
}
\arguments{
\item{observations}{ Data frame with x,y coordinates of observations and possible covariates }
\item{predGrid}{ Data frame with x,y coordinates of prediction locations when \code{method} is "ssa" }
\item{candidates}{ When action is "add", candidates is data frame with x,y coordinates or a 
\code{\link[sp:SpatialPolygons]{SpatialPolygonsDataFrame}} }
\item{action}{ Character string indicating which type of action to simulate: 
"add" to add new measurement stations to the existing network or "del" to turn off existing stations }
\item{nDiff}{ Number of stations to add or delete }
\item{model}{ Variogram model:object of class \code{variogramModel},
         as generated by \code{\link[gstat:vgm]{vgm}}}
\item{nr_iterations}{ number of iterations before stoping }
\item{plotOptim}{ plot or not the result; TRUE by default }
\item{...}{ other arguments to be passed on lower level functions }
}


\details{
This function applies SSA algorithm for the special case of optimization criterion MUKV. With covariates, 
the function takes a universal kriging model into account. Stopping criterion of the optimization procedure 
uses a number of searching steps without improvement in the design.
}

\value{
Data frame of optimized locations
}

\references{
\url{http://www.intamap.org/}
}
\author{ Olivier Baume }
\keyword{spatial}
