% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidalgo_postproc.R
\name{id_by_class}
\alias{id_by_class}
\alias{print.hidalgo_class}
\title{Stratification of the \code{id} by an external categorical variable}
\usage{
id_by_class(object, class)

\method{print}{hidalgo_class}(x, ...)
}
\arguments{
\item{object}{object of class \code{Hidalgo}, the output of the
\code{Hidalgo()} function.}

\item{class}{factor according to the observations should be stratified by.}

\item{x}{object of class \code{hidalgo_class}, the output of the \code{id_by_class()} function.}

\item{...}{other arguments passed to specific methods.}
}
\value{
a \code{data.frame} containing the posterior \code{id} means,
medians, and standard deviations stratified by the levels of the variable
\code{class}.
}
\description{
The function computes summary statistics (mean, median, and standard
deviation) of the post-processed chains of the intrinsic dimension stratified
by an external categorical variable.
}
\examples{
\donttest{
X            <- replicate(5,rnorm(500))
X[1:250,1:2] <- 0
oracle       <- rep(1:2,rep(250,2))
h_out        <- Hidalgo(X)
id_by_class(h_out,oracle)
}

}
\seealso{
\code{\link{Hidalgo}}
}
