% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informSCI.R
\name{weightsGTP}
\alias{weightsGTP}
\title{Function for determining the (monotone part of the) local significance levels}
\usage{
weightsGTP(mu, g, weights, alpha, q, mu_0)
}
\arguments{
\item{mu}{A real-valued vector (-\code{Inf} is also allowed) of dimension m
indicating which dual graph should be created and which null hypotheses
should be rejected. \code{mu[i]>mu_0[i]} iff the corresponding hypothesis is
rejected, \eqn{1\leq i\leq m}.}

\item{g}{A numeric square matrix of transition weights for the graphical
test procedure.}

\item{weights}{A numeric vector of dimension m of initial weights for the
graphical test procedure.}

\item{alpha}{Overall level of the graphical test procedure.}

\item{q}{A numeric vector of dimension m of information weights.}

\item{mu_0}{A numeric vector of dimension m of bounds of the null hypotheses.}
}
\value{
Returns a numeric vector of dimension m (\code{eta.mu}) used for
solving the key equation of the \code{informSCI} algorithm. It contains the
local levels in \code{mu} divided by \code{q^{max(mu-mu_0,0)}} or divided by
adapted information weights (only if \code{q[i]>0}).
}
\description{
Function for determining the monotone part (\code{eta.mu}) of the local
significance levels for the key equation of the informative SCI algorithm.
The function creates dual graphs and rejects some of its hypotheses to
obtain the local significance levels.
}
\details{
m = number of hypotheses.

The function is not suitable if for all \eqn{1\leq i\leq m} it holds
\code{q[i]==0} and \code{mu[i]>mu_0[i]}.
}
\keyword{internal}
