% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influxdb_client.R
\docType{class}
\name{InfluxDBClient}
\alias{InfluxDBClient}
\title{InfluxDBClient}
\format{
An \code{R6Class} object
}
\description{
Client for querying from and writing to InfluxDB 2.x.
}
\examples{
\dontrun{
# Instantiation
client <- InfluxDBClient$new(url = "http://localhost:8086",
                             token = "my-token",
                             org = "my-org")

# Query
data <- client$query('from(bucket: "my-bucket") |> range(start: -1h)')

# Write
data <- data.frame(...)
client$write(data, bucket = "my-bucket", precision = "us",
             measurementCol = "name",
             tagCols = c("location", "id"),
             fieldCols = c("altitude", "temperature"),
             timeCol = "time")

# Ready status
ready <- client$ready()

# Healt info
ready <- client$health()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{url}}{Database URL}

\item{\code{token}}{Authentication token}

\item{\code{org}}{Organization name}

\item{\code{dialect}}{Flux dialect}

\item{\code{retryOptions}}{Retry options}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{InfluxDBClient$new()}}
\item \href{#method-health}{\code{InfluxDBClient$health()}}
\item \href{#method-query}{\code{InfluxDBClient$query()}}
\item \href{#method-ready}{\code{InfluxDBClient$ready()}}
\item \href{#method-write}{\code{InfluxDBClient$write()}}
\item \href{#method-clone}{\code{InfluxDBClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates instance of \code{InfluxDBClient}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InfluxDBClient$new(url, token, org, retryOptions = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{InfluxDB instance URL}

\item{\code{token}}{Authentication token}

\item{\code{org}}{Organization name}

\item{\code{org}}{Retry options. See \code{RetryOptions} for details. Set to \code{TRUE}
for default retry options. Default is \code{NULL} which disables retries.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-health"></a>}}
\if{latex}{\out{\hypertarget{method-health}{}}}
\subsection{Method \code{health()}}{
Gets health info of the InfluxDB instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InfluxDBClient$health()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list with \code{name}, \code{message}, \code{status},
\code{version}, \code{commit} elements or error
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-query"></a>}}
\if{latex}{\out{\hypertarget{method-query}{}}}
\subsection{Method \code{query()}}{
Queries data in the InfluxDB instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InfluxDBClient$query(
  text,
  POSIXctCol = c(`_time` = "time"),
  flatSingleResult = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{Flux query}

\item{\code{POSIXctCol}}{Flux time to (new) \code{POSIXct} column mapping (named list).
Default is \code{c("_time"="time")}. Use \code{NULL} to skip it.}

\item{\code{flatSingleResult}}{Whether to return simple list when response contains
only one result. Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of data frames. Data frame represents Flux table.
It can be a named list of nested lists of data frames when query response contains
multiple results (see Flux \href{https://docs.influxdata.com/influxdb/v2.0/reference/flux/stdlib/built-in/outputs/yield/}{yield}),
or a simple list of data frames for single result response.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ready"></a>}}
\if{latex}{\out{\hypertarget{method-ready}{}}}
\subsection{Method \code{ready()}}{
Gets readiness status of the InfluxDB instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InfluxDBClient$ready()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list with \code{status}, \code{started} and \code{up} elements or error
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write"></a>}}
\if{latex}{\out{\hypertarget{method-write}{}}}
\subsection{Method \code{write()}}{
Writes data to the InfluxDB instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InfluxDBClient$write(
  x,
  bucket,
  batchSize = 5000,
  precision = c("ns", "us", "ms", "s"),
  measurementCol = "_measurement",
  tagCols = NULL,
  fieldCols = c(`_field` = "_value"),
  timeCol = "_time",
  object = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Data as (list of) \code{data.frame}}

\item{\code{bucket}}{Target bucket name}

\item{\code{batchSize}}{Batch size. Positive number or \code{FALSE} to disable.
Default is \code{5000}.}

\item{\code{precision}}{Time precision}

\item{\code{measurementCol}}{Name of measurement column. Default is \code{"_measurement"}.}

\item{\code{tagCols}}{Names of tag (index) columns}

\item{\code{fieldCols}}{Names of field columns. In case of unpivoted data
previously retrieved from InfluxDB, use default value ie. named list
\code{c("_field"="_value")}.
For all other cases, just use simple vector of column names (see Examples).}

\item{\code{timeCol}}{Name of time column. The column values should be either
of \code{nanotime} or \code{POSIXct} type. Default is \code{"_time"}.}

\item{\code{object}}{\emph{Output object name. For dry-run operation, specify the name
of the object to receive the output. Default is \code{NULL}. For debugging purposes.}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InfluxDBClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
