% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-ts-prop-test.R
\name{infer_ts_prop_test}
\alias{infer_ts_prop_test}
\alias{ts_prop_test}
\alias{infer_ts_prop_grp}
\alias{ts_prop_grp}
\alias{infer_ts_prop_calc}
\alias{ts_prop_calc}
\title{Two Sample Test of Proportion}
\usage{
infer_ts_prop_test(data, var1, var2, alternative = c("both", "less",
  "greater", "all"), ...)

infer_ts_prop_grp(data, var, group, alternative = c("both", "less", "greater",
  "all"))

infer_ts_prop_calc(n1, n2, p1, p2, alternative = c("both", "less", "greater",
  "all"), ...)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{var1}{factor; column in \code{data}}

\item{var2}{factor; column in \code{data}}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter}

\item{...}{additional arguments passed to or from other methods}

\item{var}{factor; column in \code{data}}

\item{group}{factor; column in \code{data}}

\item{n1}{sample 1 size}

\item{n2}{sample 2 size}

\item{p1}{sample 1 proportion}

\item{p2}{sample 2 proportion}
}
\value{
an object of class \code{"infer_ts_prop_test"}.
An object of class \code{"infer_ts_prop_test"} is a list containing the
following components:

\item{n1}{sample 1 size}
\item{n2}{sample 2 size}
\item{phat1}{sample 1 proportion}
\item{phat2}{sample 2 proportion}
\item{z}{z statistic}
\item{sig}{p-value for z statistic}
\item{alt}{alternative hypothesis}
}
\description{
Tests on the equality of proportions using
large-sample statistics. It tests that a sample has the same proportion
within two independent groups or two samples have the same proportion.
}
\section{Deprecated Functions}{

\code{ts_prop_test()}, \code{ts_prop_grp()} and \code{ts_prop_calc()} have
been deprecated. Instead use \code{infer_ts_prop_test()},
\code{infer_ts_prop_grp()} and \code{infer_ts_prop_calc()}.
}

\examples{
# using variables
# lower tail
infer_ts_prop_test(treatment, treatment1, treatment2,
alternative = 'less')

# using groups
# lower tail
infer_ts_prop_grp(treatment2, outcome, female,
alternative = 'less')

# using sample size and proportions
# lower tail
infer_ts_prop_calc(n1 = 30, n2 = 25, p1 = 0.3, p2 = 0.5, alternative = 'less')

}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{prop.test}}
}
