% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_sift.R
\name{network_sift}
\alias{network_sift}
\title{network_sift}
\usage{
network_sift(
  network_table,
  matrix = NULL,
  meta_data = NULL,
  pseudotime_column = NULL,
  method = c("entropy", "max"),
  entropy_method = c("Shannon", "Renyi"),
  effective_entropy = FALSE,
  shuffles = 100,
  entropy_nboot = 300,
  history_length = 1,
  entropy_p_value = 0.05,
  cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{network_table}{network_table}

\item{matrix}{The expression matrix.}

\item{meta_data}{The meta data for cells or samples.}

\item{pseudotime_column}{The column of pseudotime.}

\item{method}{method The method used for filter edges. Could be choose \code{"entropy"} or \code{"max"}.}

\item{entropy_method}{If setting \code{'method'} to \code{'entropy'},
could be choose \code{"Shannon"} or \code{"Renyi"} to compute entropy.}

\item{effective_entropy}{Logical value, using effective entropy to filter weights or not.}

\item{shuffles}{The number of shuffles used to calculate the effective transfer entropy. Default is \code{'shuffles'} = 100.}

\item{entropy_nboot}{entropy_nboot}

\item{history_length}{history_length}

\item{entropy_p_value}{P value.}

\item{cores}{Number of CPU cores used. Setting to parallelize the computation with \code{\link[foreach]{foreach}}.}

\item{verbose}{Print detailed information.}
}
\value{
Filtered network table
}
\description{
network_sift
}
\examples{
data("example_matrix")
data("example_ground_truth")
network_table <- inferCSN(example_matrix)
network_table_filtered <- network_sift(network_table)
data("example_meta_data")
network_table_filtered_entropy <- network_sift(
  network_table,
  matrix = example_matrix,
  meta_data = example_meta_data,
  pseudotime_column = "pseudotime",
  history_length = 2,
  shuffles = 0,
  entropy_nboot = 0
)

network.heatmap(
  example_ground_truth[, 1:3],
  heatmap_title = "Ground truth",
  show_names = TRUE,
  rect_color = "gray70"
)
network.heatmap(
  network_table,
  heatmap_title = "Raw",
  show_names = TRUE,
  rect_color = "gray70"
)
network.heatmap(
  network_table_filtered,
  heatmap_title = "Filtered",
  show_names = TRUE,
  rect_color = "gray70"
)
network.heatmap(
  network_table_filtered_entropy,
  heatmap_title = "Filtered by entropy",
  show_names = TRUE,
  rect_color = "gray70"
)

auc.calculate(
  network_table,
  example_ground_truth,
  plot = TRUE
)
auc.calculate(
  network_table_filtered,
  example_ground_truth,
  plot = TRUE
)
auc.calculate(
  network_table_filtered_entropy,
  example_ground_truth,
  plot = TRUE
)
}
