% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.visualization.R
\name{network.heatmap}
\alias{network.heatmap}
\title{The heatmap of network}
\usage{
network.heatmap(
  weight_table,
  switch_watrix = TRUE,
  heatmap_size = NULL,
  heatmap_title = NULL,
  heatmap_color = NULL,
  show_names = FALSE,
  legend_name = NULL
)
}
\arguments{
\item{weight_table}{The weight data table of network}

\item{switch_watrix}{switch_watrix}

\item{heatmap_size}{heatmap_size}

\item{heatmap_title}{heatmap_title}

\item{heatmap_color}{heatmap_color}

\item{show_names}{show_names}

\item{legend_name}{legend_name}
}
\value{
Return a heatmap of ggplot2 object
}
\description{
The heatmap of network
}
\examples{
library(inferCSN)
data("example_matrix")
data("example_ground_truth")
weight_table <- inferCSN(example_matrix)
p1 <- network.heatmap(example_ground_truth,
  heatmap_title = "Ground truth"
)

p2 <- network.heatmap(weight_table,
  legend_name = "Weight2",
  heatmap_title = "inferCSN"
)

ComplexHeatmap::draw(p1 + p2)

p3 <- network.heatmap(weight_table,
  heatmap_title = "inferCSN",
  heatmap_color = c("#20a485", "#410054", "#fee81f")
)

p4 <- network.heatmap(weight_table,
  heatmap_title = "inferCSN",
  legend_name = "Weight2",
  heatmap_color = c("#20a485", "white", "#fee81f")
)

ComplexHeatmap::draw(p3 + p4)

p5 <- network.heatmap(
  weight_table,
  heatmap_title = "inferCSN",
  show_names = TRUE
)
p5
}
